""" recur_resnet.py
    Deep thinking model architecture
    November 2020
"""

import torch
import torch.nn as nn
import torch.nn.functional as F

# Ignore statemenst for pylint:
#     Too many branches (R0912), Too many statements (R0915), No member (E1101),
#     Not callable (E1102), Invalid name (C0103), No exception (W0702)
# pylint: disable=R0912, R0915, E1101, E1102, C0103, W0702, R0914

iters = 0
class BasicBlock(nn.Module):
    """Basic residual block class"""
    expansion = 1

    def __init__(self, in_planes, planes, stride=1):
        super(BasicBlock, self).__init__()
        self.conv1 = nn.Conv2d(
            in_planes, planes, kernel_size=3, stride=stride, padding=1, bias=False)

        self.bn11 = nn.BatchNorm2d(planes)
        self.bn12 = nn.BatchNorm2d(planes)
        self.bn13 = nn.BatchNorm2d(planes)
        self.bn14 = nn.BatchNorm2d(planes)
        self.bn15 = nn.BatchNorm2d(planes)
        self.conv2 = nn.Conv2d(planes, planes, kernel_size=3,
                               stride=1, padding=1, bias=False)
        self.bn21 = nn.BatchNorm2d(planes)
        self.bn22 = nn.BatchNorm2d(planes)
        self.bn23 = nn.BatchNorm2d(planes)
        self.bn24 = nn.BatchNorm2d(planes)
        self.bn25 = nn.BatchNorm2d(planes)
        self.shortcut = nn.Sequential()
        if stride != 1 or in_planes != self.expansion*planes:
            self.shortcut = nn.Sequential(
                nn.Conv2d(in_planes, self.expansion*planes,
                          kernel_size=1, stride=stride, bias=False)
            )

    def forward(self, x):
        # print(f"F.relu(self.bn1{iters}(self.conv1(x)))")
        out = eval(f"F.relu(self.bn1{iters}(self.conv1(x)))")
        out = eval(f"self.bn2{iters}(self.conv2(out))")
        # out = F.relu(self.conv1(x))
        # out = self.conv2(out)
        out += self.shortcut(x)
        out = F.relu(out)
        return out

class RecurResNet_DenseNet(nn.Module):
    """RecurResNet_DenseNet model class"""

    def __init__(self, block, num_blocks, num_classes=10, iters=5, feature_scale=1):
        super(RecurResNet_DenseNet, self).__init__()
        self.iters = iters
        self.in_planes = int(feature_scale*64)
        self.num_classes = num_classes
        self.conv1 = nn.Conv2d(3, int(feature_scale * 64), kernel_size=3,
                               stride=2, padding=1, bias=False)
        self.conv2 = nn.Conv2d(int(feature_scale * 64), int(feature_scale * 64),
                               kernel_size=3, stride=1, padding=1, bias=False)
        layers = []
        for i in range(len(num_blocks)):
            layers.append(self._make_layer(block, int(feature_scale*64), num_blocks[i], stride=1))

        self.recur_block = nn.Sequential(*layers)
        self.shortcut1 = nn.Conv2d(int(feature_scale * 64), int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.shortcut2 = nn.Conv2d(int(feature_scale * 64) * 2, int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.shortcut3 = nn.Conv2d(int(feature_scale * 64) * 3, int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.shortcut4 = nn.Conv2d(int(feature_scale * 64) * 4, int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.conv3 = nn.Conv2d(int(feature_scale*64), 512, kernel_size=3,
                               stride=2, padding=1, bias=False)
        self.linear = nn.Linear(512, num_classes)

    def _make_layer(self, block, planes, num_blocks, stride):
        strides = [stride] + [1]*(num_blocks-1)
        layers = []
        for strd in strides:
            layers.append(block(self.in_planes, planes, strd))
            self.in_planes = planes * block.expansion
        return nn.Sequential(*layers)

    def forward(self, x):
        self.thoughts = torch.zeros((self.iters, x.shape[0], self.num_classes)).to(x.device)
        temp = torch.tensor([]).to(x.device)

        out = F.relu(self.conv1(x))
        for i in range(self.iters):
            out = self.recur_block(out)

            if i != self.iters - 1:
                temp = torch.cat((temp, out), dim=1)
                out = eval(f"self.shortcut{i+1}")(temp)

        thought = F.relu(self.conv3(out))
        thought = F.avg_pool2d(thought, 8)
        thought = thought.view(thought.size(0), -1)
        self.thoughts[i] = self.linear(thought)
        return self.thoughts[-1]

class RecurResNet_DenseNet_bn(nn.Module):
    """RecurResNet_DenseNet_bn model class"""

    def __init__(self, block, num_blocks, num_classes=10, iters=5, feature_scale=1):
        super(RecurResNet_DenseNet_bn, self).__init__()
        self.iters = iters
        self.in_planes = int(feature_scale*64)
        self.num_classes = num_classes
        self.conv1 = nn.Conv2d(3, int(feature_scale * 64), kernel_size=3,
                               stride=2, padding=1, bias=False)
        self.bn1 = nn.BatchNorm2d(int(feature_scale * 64))
        self.conv2 = nn.Conv2d(int(feature_scale * 64), int(feature_scale * 64),
                               kernel_size=3, stride=1, padding=1, bias=False)
        layers = []
        for i in range(len(num_blocks)):
            layers.append(self._make_layer(block, int(feature_scale*64), num_blocks[i], stride=1))

        self.recur_block = nn.Sequential(*layers)
        self.bn2 = nn.BatchNorm2d(int(feature_scale * 64))
        self.shortcut1 = nn.Conv2d(int(feature_scale * 64), int(feature_scale * 64),
                               kernel_size=1, stride=1, padding=0, bias=False)
        self.bns1 = nn.BatchNorm2d(int(feature_scale * 64))
        self.shortcut2 = nn.Conv2d(int(feature_scale * 64) * 2, int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.bns2 = nn.BatchNorm2d(int(feature_scale * 64))
        self.shortcut3 = nn.Conv2d(int(feature_scale * 64) * 3, int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.bns3 = nn.BatchNorm2d(int(feature_scale * 64))
        self.shortcut4 = nn.Conv2d(int(feature_scale * 64) * 4, int(feature_scale * 64),
                                   kernel_size=1, stride=1, padding=0, bias=False)
        self.bns4 = nn.BatchNorm2d(int(feature_scale * 64))
        # self.shortcut5 = nn.Conv2d(int(feature_scale * 64) * 5, int(feature_scale * 64),
        #                            kernel_size=1, stride=1, padding=0, bias=False)

        self.conv3 = nn.Conv2d(int(feature_scale*64), 512, kernel_size=3,
                               stride=2, padding=1, bias=False)
        self.bn3 = nn.BatchNorm2d(512)
        self.linear = nn.Linear(512, num_classes)

    def _make_layer(self, block, planes, num_blocks, stride):
        strides = [stride] + [1]*(num_blocks-1)
        layers = []
        for strd in strides:
            layers.append(block(self.in_planes, planes, strd))
            self.in_planes = planes * block.expansion
        return nn.Sequential(*layers)

    def forward(self, x):
        self.thoughts = torch.zeros((self.iters, x.shape[0], self.num_classes)).to(x.device)
        temp = torch.tensor([]).to(x.device)

        out = F.relu(self.bn1(self.conv1(x)))
        for i in range(self.iters):
            global iters
            iters = i + 1
            out = self.recur_block(out)

            if i != self.iters - 1:
                temp = torch.cat((temp, out), dim=1)
                out = eval(f"self.shortcut{i+1}")(temp)
                out = eval(f"self.bns{i+1}")(out)

        thought = F.relu(self.bn3(self.conv3(out)))
        thought = F.avg_pool2d(thought, 8)
        thought = thought.view(thought.size(0), -1)
        self.thoughts[i] = self.linear(thought)
        return self.thoughts[-1]

def recur_resnet_densenet_7_2_1_4(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=4)

def recur_resnet_densenet_11_2_2_4(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=4)

def recur_resnet_densenet_15_2_3_4(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=4)

def recur_resnet_densenet_19_2_4_4(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=4)

def recur_resnet_densenet_7_2_1_5(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=5)

def recur_resnet_densenet_11_2_2_5(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=5)

def recur_resnet_densenet_15_2_3_5(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=5)

def recur_resnet_densenet_19_2_4_5(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=5)

def recur_resnet_densenet_7_2_1_6(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=6)

def recur_resnet_densenet_11_2_2_6(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=6)

def recur_resnet_densenet_15_2_3_6(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=6)

def recur_resnet_densenet_19_2_4_6(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=6)

def recur_resnet_densenet_7_2_1_7(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=7)

def recur_resnet_densenet_11_2_2_7(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=7)

def recur_resnet_densenet_15_2_3_7(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=7)

def recur_resnet_densenet_19_2_4_7(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=7)

def recur_resnet_densenet_7_2_1_8(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=8)

def recur_resnet_densenet_11_2_2_8(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=8)

def recur_resnet_densenet_15_2_3_8(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=8)

def recur_resnet_densenet_19_2_4_8(num_outputs=10):
    return RecurResNet_DenseNet(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=8)



def recur_resnet_densenet_7_2_1_4_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=4)

def recur_resnet_densenet_11_2_2_4_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=4)

def recur_resnet_densenet_15_2_3_4_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=4)

def recur_resnet_densenet_19_2_4_4_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=4)

def recur_resnet_densenet_7_2_1_5_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=5)

def recur_resnet_densenet_11_2_2_5_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=5)

def recur_resnet_densenet_15_2_3_5_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=5)

def recur_resnet_densenet_19_2_4_5_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=5)

def recur_resnet_densenet_7_2_1_6_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=6)

def recur_resnet_densenet_11_2_2_6_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=6)

def recur_resnet_densenet_15_2_3_6_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=6)

def recur_resnet_densenet_19_2_4_6_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=6)

def recur_resnet_densenet_7_2_1_7_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=7)

def recur_resnet_densenet_11_2_2_7_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=7)

def recur_resnet_densenet_15_2_3_7_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=7)

def recur_resnet_densenet_19_2_4_7_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=7)

def recur_resnet_densenet_7_2_1_8_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=1, feature_scale=8)

def recur_resnet_densenet_11_2_2_8_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=2, feature_scale=8)

def recur_resnet_densenet_15_2_3_8_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=3, feature_scale=8)

def recur_resnet_densenet_19_2_4_8_bn(num_outputs=10):
    return RecurResNet_DenseNet_bn(BasicBlock, [2], num_classes=num_outputs, iters=4, feature_scale=8)
